;;; -*- Mode:Common-Lisp; Package:TV; Base:10; Fonts:(CPTFONT HL10B HL12BI HL12B CPTFONTB)1; *Patch-File: T -*-

1;*;1;                     RESTRICTED RIGHTS LEGEND          *
;1;; Use, duplication, or disclosure by the Government is subject to*
;1;; restrictions as set forth in subdivision (b)(3)(ii) of the Rights in*
;1;; Technical Data and Computer Software clause at 52.227-7013.*
;1;;                   TEXAS INSTRUMENTS INCORPORATED.*
;1;;                            P.O. BOX 149149*
;1;;                         AUSTIN, TEXAS 78714-9149*
;1;;                             MS 2151*
;1;; Copyright (C) 1986,1987,1988, 1989 Texas Instruments Incorporated. All rights reserved.*

;;;----------------------------------------------------------------------
;;; This software developed by:
;;;	James Rice
;;; at the Stanford University Knowledge Systems Lab in 1986, 1987.
;;;
;;; This work was supported in part by:
;;;	DARPA Grant F30602-85-C-0012

;;;----------------------------------------------------------------------
;;;  Much of this file is derived from code licensed from Texas Instruments
;;;  Inc.  Since we'd like them to adopt these changes, we're claiming
;;;  no rights to them, however, the following restrictions apply to the
;;;  TI code:
;;; Your rights to use and copy Explorer System Software must be obtained
;;; directly by license from Texas Instruments Incorporated.  Unauthorized
;;; use is prohibited.
;;;----------------------------------------------------------------------

;1;; This file contains a collection of new commands that can be added to the inspector.*

(DEFVAR 4*inspector-enhancements-to-add** :all
"2Can have the value :All, in which case all commands are loaded,
 :Menu in which case the user is prompted, or a list of commands to load.*")

(DEFPARAMETER 4*inspector-enhancements-commands**
  ;1;* TAC 08-18-891 - do not advertise that this command is available in the inspector*
  ;1; *'(("3Debug Stack Group*" :value (nil ((dbg-sg-cmd t)) nil)))
  nil
"2This is a list of the commands which can be added to the Inspector.  The
 structure of this list is as follows :-
 It is made of items.  Each item is a list of the form (Menustring :Value spec)
 the spec is used to determine which commands for which tools is represented
 by the menu item.  The spec is a list of the form
 (nil inspector-commands nil)
 Each element of inspector-commands has the form
 (command-name put-in-frames-menu-p).*")

(DEFUN 4install-inspector-commands* ()
"2Installs all of the commands that the user wants.*"
  (select-and-install-commands *inspector-enhancements-commands*
			       *inspector-enhancements-to-add*))

;1-------------------------------------------------------------------------------*
;1; Define a debug stack group command.  JPR 21 Nov 86.*

(DEFCOMMAND 4dbg-sg-cmd* nil			
  '(:description 
     "3Debug a stack group.*"
     :names ("3Dbg SG*") :keys (#\h-s))
  (DECLARE (SPECIAL user history = inspectors frame)) (SEND user :clear-screen)
  (FORMAT user "3~&Type or mouse a process or stack group to debug:*")
  (MULTIPLE-VALUE-BIND (value punt-p) (inspect-get-value-from-user user history inspectors)
    (OR punt-p (PROCESS-RUN-FUNCTION "3Window Debugger from Inspector*" #'eh::debug-a-stack-group value)))
  (SEND frame :handle-prompt))
;1-------------------------------------------------------------------------------*

;(install-inspector-commands)1 * ;1 TAC 09-05-89 there is only one that has been commented out*

;1*
;1 TAC 08-08-89 - printing and formating code has been moved to PRINT-AND-FORMAT*
;1                file in order to handle compile and load dependencies.*
;1*

;1-------------------------------------------------------------------------------*

;1 TAC 08-08-89 - code that follows uses formats defined in PRINT-AND-FORMAT*

(DEFUN 4format-list* (collection slashify)
"2Is passed a collection and a flag which denotes slashification.  It returns a
 list of pairs, whose first elements are the elements of the collection and
 the second elements are all the slashify flag.*"
  (LOOP for i in collection
	collect (LIST i slashify)))

(DEFUN 4print-out-with-separator-1*
       (list-to-print slashify whole-thing separator-string left-bracket
	right-bracket alternate-p truncated)
  (IF alternate-p
      (PROGN
	(FORMAT *standard-output* "3~~~A~*"
		(LIST whole-thing nil left-bracket)
		(LIST (FIRST list-to-print) slashify)
		separator-string
		(LIST (SECOND list-to-print) slashify))
	(LOOP for (a b) on (format-list (REST (REST list-to-print)) slashify)
	      by #'CDDR
	      do (FORMAT *standard-output* "3~A~~A~*"
			 separator-string a separator-string b))
	(FORMAT *standard-output* "3~A~A~*"
		(IF truncated separator-string "")
		(IF truncated "3...*" "")
		(LIST whole-thing nil right-bracket)))
      (PROGN
	(FORMAT *standard-output* "3~~*"
		(LIST whole-thing nil left-bracket)
		(LIST (FIRST list-to-print) slashify))
	(LOOP for a in (format-list (REST list-to-print) slashify)
	      do (FORMAT *standard-output* "3~A~*" separator-string a))
	(FORMAT *standard-output* "3~A~A~*"
		(IF truncated separator-string "")
		(IF truncated "3...*" "")
		(LIST whole-thing nil right-bracket)))))

(DEFUN 4print-out-with-separator*
  (LIST &key (slashify *print-escape*)
             (whole-thing list)
	     (separator "3 *")
	     (left-bracket "")
	     (right-bracket "")
	     (depth 0)
	     (alternate-p nil))
"2Formats a list of things, taking three arguments.  The first argument is the
 list of things to print out.  The second is the slashification to use for all
 of them and the third is something which can be converted into a string to use
 as a separator.  The list of things is printed out with the separator princed
 between them, using the ~ format directive.  This means that the elements
 will come out mouse sensitive if they are printed out by in an inspector pane
 then the thing to be printed is printed out mouse sensitively as long as the
 *inspect-details* flag is true.
 Thus (print-out-with-separator '(a b c) slashify \", \" nil nil 0)
 will print out
 A list : - foo:a, foo:b, foo:c
 if slashify is true and
 A list : - a, b, c
 if it is not.
 If separator is nil then a space is printed instead.*"
  (DECLARE (UNSPECIAL list slashify whole-thing separator brackets)
	   (optimize (safety 0) (speed 3)))
  (LET ((too-deep (AND depth *print-level* (> depth *print-level*))))
       (IF too-deep
	    (FORMAT *standard-output* "3~*" (LIST whole-thing nil "3#*"))
	    (LET ((truncated (AND *print-length*
				  (CONSP (NTHCDR *print-length* list))))
		  (separator-string
		    (IF (EQUAL nil separator) "3 *" (STRING separator))))
		 (LET ((list-to-print
			 (IF truncated (FIRSTN *print-length* list) list)))
		      (IF (EQUAL nil list-to-print)
			  nil
			  (print-out-with-separator-1 list-to-print slashify
			    whole-thing separator-string left-bracket
			    right-bracket alternate-p truncated)))))))

;1---------------------------------------------------------------------------*

;1 TAC 08-09-89 - more format definitions that use the functions above  *

;1; Formats a list of things with spaces between them.  It takes two args.*
;1; The first is a list of items to print.  The second is slashify.*

format:
(format::defformat format:: (:multi-arg) (args params)
"3Formats a list of things, taking two arguments.  The first argument is the
 list of things to print out.  The second is the slashification to use for all
 of them.  The list of things is printed out with spaces between them, using
 the ~ format directive.  This means that the elements will come out mouse
 sensitive if they are printed out in an inspector pane then the
 thing to be printed is printed out mouse sensitively as long as the
 *inspect-details* flag is true.
 Thus (format stream 'A list :- ~' '(a b c) slashify) will print out
 A list :- foo:a foo:b foo:c if slashify is true and A list :- a b c if it is not.*"
  (IGNORE params)
  (tv::print-out-with-separator (FIRST args)
    :slashify (SECOND args)
    :whole-thing (FIRST args)
    :separator "3 *"
    :depth 1)
  (REST (REST args)))

format:
(DEFPROP 4format::* 2 format::number-of-arguments)

format:
(format::defformat format:: (:multi-arg) (args params)
"3Formats a list of things, taking two arguments.  The first argument is the
 list of things to print out.  The second is the slashification to use for all
 of them.  The alternate elements in the list of things are printed out using
 the ~ format directive.  This means that these elements will come out mouse
 sensitive if they are printed out in an inspector pane then the thing to be
 printed is printed out mouse sensitively as long as the *inspect-details*
 flag is true.
 Thus (format stream 'A list :- ~' '(a b c) slashify) will print out
 A list :- foo:a foo:b foo:c if slashify is true and A list :- a b c if it is not.*"
  (IGNORE params)
  (tv::print-out-with-separator (FIRST args)
    :slashify (SECOND args)
    :whole-thing (FIRST args)
    :separator "3 *"
    :depth 1
    :alternate-p t)
  (REST (REST args)))

format:
(DEFPROP 4format::* 2 format::number-of-arguments)

;1; Formats a list of things with spaces between them.  It takes two args.*
;1; The first is a list of items to print.  The second is slashify.*
format:
(format::defformat format:: (:multi-arg) (args params)
" Formats a list of things, taking seven arguments.
 i)   The list of things to print out.
 ii)  The slashification to use for all of them.
 iii) The whole structure of which i) is a part.
 iv)  Something which can be converted into a string to use as a separator.
 v)   A string which is used as the left bracket for i).  This could be,
      for instance, \"[\".
 vi)  A string which is used as the right bracket for i).  This could be,
      for instance, \"]\".
 vii) The current print depth level.

 The list of things is printed out with the separator princed between them,
 using the ~ format directive and with the brackets princed at each end. 
 This means that the elements will come out mouse sensitive if they are
 printed out in an inspector pane then the thing to be printed is printed
 out mouse sensitively as long as the *inspect-details* flag is true.
 Thus (format stream \"A list :- ~\" '(a b c) slashify fred \", \" \"{\" \"}\" 0)
 will print out as A list :- {foo:a, foo:b, foo:c} if slashify is true and 
 A list :- {a, b, c} if it is not."
  (IGNORE params)
  (tv::print-out-with-separator (FIRST args)
    :slashify      (SECOND args)
    :whole-thing   (THIRD  args)
    :separator     (FOURTH args)
    :left-bracket  (FIFTH  args)
    :right-bracket (SIXTH  args)
    :depth   (+ 1 (SEVENTH args)))
  (NTHCDR 7 args))

format:
(DEFPROP 4format::* 7 format::number-of-arguments)

;1-------------------------------------------------------------------------------*
;1 TAC 08-15-89 - advice moved to INSPECT.LISP*
;1; Extend the definition for the printing of functions.*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE print-fef-instruction :around :show-dbis nil*
;1       ;;; Spots non instruction type items and prints them with the normal*
;1       ;;; inspect printer.*
;1       (IF (CONSP (FIRST arglist))*
;	1   (inspect-printer (FIRST arglist) nil (THIRD arglist) nil)*
;	1   :do-it)))*
;1-------------------------------------------------------------------------------*

;1(DEFVAR *show-dbis-for-fefs-in-inspector* t*
;1"When true the name and DBIS for functions is printed in the inspector when*
;1 you inspect a fef.")*

;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE fef-display-list :around :show-dbis nil*
;1       ;;; Print the function name and DBIS for the FEF.  Do this by putting an*
;1       ;;; extra item onto the list of items.  This item is of a different*
;1       ;;; format from the others but wil be handled by the advice above.*
;1       (LET ((results (MULTIPLE-VALUE-LIST :do-it)))*
;	1    (LET ((struct (CATCH-ERROR*
;			1    (sys:get-debug-info-struct (FIRST arglist))*
;			1    nil))*
;		1  (name (CATCH-ERROR (FUNCTION-NAME (FIRST arglist)) nil)))*
;		1 (IF (AND *show-dbis-for-fefs-in-inspector* name struct)*
;		1     (PROGN (SETF (FIRST results)*
;				1  (CONS (LIST "Function name: "*
;					1      `(:item1 named-structure-p ,name)*
;					1      ", DBIS is: "*
;					1      `(:item1 named-structure-p ,struct))*
;					1(FIRST results)))*
;			1    (VALUES-LIST results))*
;		1     (VALUES-LIST results))))))*

;1-------------------------------------------------------------------------------*

;1;; By JPR.*
(DEFVAR 4*default-inspect-fonts** '(fonts:cptfont fonts:hl10b fonts:tr10bi)
"2A list of fonts to use if the inspector tries to print out a fontified object
 and finds that the font in the font map is the same as the base font.*")

(DEFUN 4set-font-map-if-you-must* (sheet)
"2Sets the font map of the sheet to something from *default-inspect-fonts*.*"
  (LET ((zero-font (font-name (AREF (SEND sheet :font-map) 0))))
       (SEND sheet :set-font-map
	     (CONS (AREF (SEND sheet :font-map) 0)
		   (REMOVE-IF #'(lambda (element)
				  (OR (SEARCH (SYMBOL-NAME element)
					      (SYMBOL-NAME zero-font))
				      (SEARCH (SYMBOL-NAME zero-font)
					      (SYMBOL-NAME element))))
			        *default-inspect-fonts*)))))

(DEFMETHOD 4(inspect-window :around :tyo*) (continuation mapping-table original-args char &rest args)
"2Prints any fontified chars specially, otherwise just prints as normal.*"
  (IF (> (CHAR-FONT char) 0)
      (LET ((old-font (SEND self :current-font)))
           (UNWIND-PROTECT
	       (PROGN (IF (EQUAL (AREF (SEND self :font-map) (CHAR-FONT char))
				 (AREF (SEND self :font-map) 0))
			  (set-font-map-if-you-must self)
			  nil)
		      (SEND self :set-current-font (CHAR-FONT char))
		      (LEXPR-FUNCALL-WITH-MAPPING-TABLE
			continuation mapping-table :tyo char args))
	     (SEND self :set-current-font old-font)))
     (LEXPR-FUNCALL-WITH-MAPPING-TABLE
	continuation mapping-table original-args)))

(DEFMETHOD 4(inspect-window :string-out*) (STRING &optional (start 0) (end nil))
"2Prints out the string with any fonts in it.*"
  (LET ((tem (IF (TYPEP string 'ARRAY) string (STRING string))))
       (LOOP for i
	     from start
	     to (IF end (- end 1) (- (ARRAY-ACTIVE-LENGTH string) 1))
	     do (SEND self :tyo (AREF tem i)))))

(DEFMETHOD 4(inspect-window :line-out*) (STRING &optional (start 0) (end nil))
"2Prints out the string with any fonts in it.*"
  (LET ((tem (IF (TYPEP string 'ARRAY) string (STRING string))))
       (LOOP for i from start to (IF end end (- (ARRAY-ACTIVE-LENGTH string) 1))
	     do (SEND self :tyo (AREF tem i)))
       (SEND self :tyo #\newline)))

;1-------------------------------------------------------------------------------*

(DEFMETHOD 4(inspect-history-window :around :tyo*)
  (continuation mapping-table original-args char &rest args)
"2Prints any fontified chars specially, otherwise just prints as normal.*"
  (IF (> (CHAR-FONT char) 0)
      (LET ((old-font (SEND self :current-font)))
           (UNWIND-PROTECT
	       (PROGN (IF (EQUAL (AREF (SEND self :font-map) (CHAR-FONT char))
				 (AREF (SEND self :font-map) 0))
			  (set-font-map-if-you-must self)
			  nil)
		      (SEND self :set-current-font (CHAR-FONT char))
		      (LEXPR-FUNCALL-WITH-MAPPING-TABLE
			continuation mapping-table :tyo char args))
	     (SEND self :set-current-font old-font)))
      (LEXPR-FUNCALL-WITH-MAPPING-TABLE
	continuation mapping-table original-args)))

(DEFMETHOD 4(inspect-history-window :string-out*) (STRING &optional (start 0) (end nil))
"2Prints out the string with any fonts in it.*"
  (LET ((tem (IF (TYPEP string 'ARRAY) string (STRING string))))
       (LOOP for i
	     from start
	     to (IF end (- end 1) (- (ARRAY-ACTIVE-LENGTH string) 1))
	     do (SEND self :tyo (AREF tem i)))))

(DEFMETHOD 4(inspect-history-window :line-out*) (STRING &optional (start 0) (end nil))
"2Prints out the string with any fonts in it.*"
  (LET ((tem (IF (TYPEP string 'ARRAY) string (STRING string))))
       (LOOP for i from start to (IF end end (- (ARRAY-ACTIVE-LENGTH string) 1))
	     do (SEND self :tyo (AREF tem i)))
       (SEND self :tyo #\newline)))

;1-------------------------------------------------------------------------------*

;1; The following code written by JPR to give better inspecting of locatives.*
;1; It tries to find the object that contains the locative and give a reasonable display of it.*

(DEFUN 4array-leader-matching-slot* (loc array)
"2Try to find the locative Loc in the array leader of Array.  Returns either the
 array leader index or nil.*"
  (LET ((leader-length (ARRAY-LEADER-LENGTH array)))
       (IF leader-length
	   (LOOP for index from 0 to (- leader-length 1)
		 when (EQ loc (LOCF (ARRAY-LEADER array index)))
		 return index
		 finally (RETURN nil))
	   nil)))

(DEFUN 4array-matching-slot* (loc array dimensions indices)
"2Try to find the locative Loc in the array Array.  Returns either the list of
 indices or nil.  Dimensions is the reversed list of Array-Dimensions.  Indices
 is an accumulating parameter of indices, initially nil.*"
  (IF (REST dimensions)
      (LOOP for index from 0 to (- (FIRST dimensions) 1) do
	    (LET ((result (array-matching-slot
			    loc array (REST dimensions)
			    (CONS index indices))))
	         (IF result (RETURN (CONS index result)) nil))
	    finally (RETURN nil))
      (LOOP for i from 0 to (- (FIRST dimensions) 1) do
	    (IF (EQ loc (APPLY #'ALOC array i indices))
		(RETURN (LIST i))
		nil)
	    finally (RETURN nil))))

(DEFUN 4array-slot-matching* (loc array)
"2Try to find the locative Loc in the array Array.  Returns either the list
 (:Leader index) if Loc if in the array leader or (:Body (indices)) if it is
 in the body of the array.*"
  (LET ((foundp (array-leader-matching-slot loc array)))
       (IF foundp
	   (LIST :leader foundp)
	   (LIST :body
		 (REVERSE (array-matching-slot
			    loc array (REVERSE (ARRAY-DIMENSIONS array)) nil))))))

(DEFMETHOD 4(basic-inspect :object-locative-array*) (loc array)
"2Make Items for a locative which points to an array element.*"
  (LET ((the-items (MULTIPLE-VALUE-LIST
		     (SEND self :object-array array)))
	(title (array-slot-matching loc array)))
       (LET ((new-item
	       (IF (EQUAL (FIRST title) :leader)
		   (LIST (FORMAT nil "3Locative to element ~S in the array ~
                                      leader of *" (SECOND title))
			 `(:item1 named-structure-p ,array)
			 "3.*")
		   (LIST (FORMAT nil "3Locative to element [~a~{, ~a~}] of *"
				 (FIRST (SECOND title)) (REST (SECOND title)))
			 `(:item1 named-structure-p ,array)
			 "3.*"))))
	    (APPLY #'VALUES nil
		   (LIST (FIRST (SECOND the-items))
			 (SECOND (SECOND the-items))
			 (CONS new-item (THIRD (SECOND the-items))))
		   (REST (REST the-items))))))

(DEFUN 4instance-slot-matching* (loc instance)
"2Try to find the locative Loc in the instance Instance.  Returns either the name
 of the IV which matches Loc or Nil.*"
  (LET ((slots (sys:flavor-all-instance-variables
		 (GET (TYPE-OF instance) 'sys::flavor))))
       (IF slots
	   (LOOP for slot in slots
		 when (EQ loc (LOCATE-IN-INSTANCE instance slot))
		 return slot
		 finally (RETURN nil))
	   nil)))

(DEFMETHOD 4(basic-inspect :object-locative-instance*) (loc instance)
"2Make Items for a locative which points to a Instance's IV.*"
  (LET ((the-items (MULTIPLE-VALUE-LIST
		     (SEND self :object-instance instance)))
	(title (instance-slot-matching loc instance)))
       (LET ((new-item (LIST (FORMAT nil "3Locative to the ~S slot of *" title)
			     `(:item1 named-structure-p ,instance)
			     "3.*")))
	    (VALUES-LIST
	      (CONS (CONS new-item (FIRST the-items)) (REST the-items))))))

(DEFUN 4slot-matching* (loc structure)
"2Try to find the locative Loc in the defstruct instance Structure.  Returns
 either the name of the Slot which matches Loc or Nil.*"
  (LET ((slots (FOURTH (GET (NAMED-STRUCTURE-P structure)
			    'sys::defstruct-description))))
       (IF slots
	   (LOOP for slot in slots
		 when (EQ loc (EVAL `(LOCF (,(SEVENTH slot) ,structure))))
		 return (FIRST slot)
		 finally (RETURN nil))
	   nil)))

(DEFMETHOD 4(basic-inspect :object-locative-named-structure*) (loc structure)
"2Make Items for a locative which points to a Defstruct's Slot.*"
  (LET ((the-items (MULTIPLE-VALUE-LIST
		     (SEND self :object-named-structure structure)))
	(title (slot-matching loc structure)))
       (LET ((new-item (LIST (FORMAT nil "3Locative to the ~S slot of *" title)
			     `(:item1 named-structure-p ,structure)
			     "3.*")))
	    (IF (AND (ARRAYP structure) (ARRAY-HAS-LEADER-P structure))
		(APPLY #'VALUES nil
		       (LIST (FIRST (SECOND the-items))
			     (SECOND (SECOND the-items))
			     (CONS new-item (THIRD (SECOND the-items))))
		       (REST (REST the-items)))
	        (VALUES-LIST
		  (CONS (CONS new-item (FIRST the-items)) (REST the-items)))))))

(DEFMETHOD 4(basic-inspect :object-locative-symbol*) (loc symbol)
"2Make Items for a locative which points to some cell of a symbol.*"
  (LET ((the-items (SEND self :object-symbol symbol))
	(title (COND ((EQ loc (VALUE-CELL-LOCATION    symbol)) "3Value*")
		     ((EQ loc (FUNCTION-CELL-LOCATION symbol)) "3Function*")
		     ((EQ loc (PROPERTY-CELL-LOCATION symbol)) "3Property*")
		     (t "3Some*"))))
      (CONS (LIST "3Locative to *"
		  `(:item1 named-structure-p ,symbol)
		   (FORMAT nil "3's ~A Cell.*" title))
	     the-items)))

(DEFUN 4headered-inspect-list-printer* (item arg stream item-no)
"2Like inspect-list-printer only it prints out a header if it finds one.
 Headers are always lists with the first element = :Header.  The second it the
 item to inspect normally.*"
  (DECLARE (:self-flavor basic-inspect))
  (IF (AND (CONSP item)
	   (EQUAL (FIRST item) :header))
      (inspect-printer (SECOND item) arg stream item-no)
      (PROGN (SETF (AREF displayed-items (- item-no top-item)) (THIRD item))
	     (SEND stream :string-out (SECOND item)))))

(DEFMETHOD 4(basic-inspect :object-list-with-header*) (header list)
"2Generates Items for List with a header as well.*"
  (LET ((the-items (MULTIPLE-VALUE-LIST (SEND self :object-list list))))
       (VALUES (CONS (LIST :header header) (FIRST the-items))
	       :list-structure 'headered-inspect-list-printer)))

(DEFMETHOD 4(basic-inspect :object-locative-cons*) (loc cons)
"2Generates Items for a list, which has Cons as a locative to it.*"
  (IGNORE loc)
  (SEND self :object-list-with-header (LIST "3Locative to the list:*") cons))

(DEFUN 4fail-locative* ()
"2Called when some locative is unprintable for some reason.*"
  (BEEP)
  (FORMAT t "3Sorry, there appears to be something wrong with the ~
             contents of this location!~%*"))

;1-------------------------------------------------------------------------------*
;1; Old object-locative-generic code below is being redefined *
;1(defmethod (basic-inspect :object-locative) (loc)*
;1  (send self :object-list (list (car loc))))*

(DEFPARAMETER 4*type-to-locative-method-mappings**
	      '((symbol :object-locative-symbol)
		(named-structure :object-locative-named-structure)
		(instance :object-locative-instance)
		(CONS :object-locative-cons)
		(ARRAY :object-locative-array)
		(t :object-locative-generic))
  "2A list of mappings from to type to method.  If a locative points to a structure
 whose type is the first of one of the elements then it invokes that method.*")

(DEFMETHOD 4(basic-inspect :object-locative-generic*) (loc structure)
"2Tries to inspect Loc in a simplistic manner, because it doesn't known what
 better to do.*"
  (IGNORE structure)
  (IF (%p-contents-safe-p loc)
      (SEND self :object-list (LIST (FIRST loc)))
      (fail-locative)))

(DEFMETHOD 4(basic-inspect :object-locative*) (loc)
"2Generates items for the locative Loc as best it can.  If Loc is a pointer to
 a slot in a defstruct, for instance, it will say which slot it is and inspect
 the defstruct.*"
  (MULTIPLE-VALUE-BIND (structure error-p)
      (CATCH-ERROR (sys::find-structure-header loc) nil)
    (IF (OR error-p (NOT structure))
	(SEND self :object-locative-generic loc structure)
	(LOOP for (type method) in *type-to-locative-method-mappings*
	      when (TYPEP structure type)
	      return (SEND self method loc structure)))))

;1-------------------------------------------------------------------------------*
;1; Patches*

;1;; Variable added by JPR.*
sys:
(DEFVAR 4sys::*top-level-p** t
"2True for top level printing.  If false then a new print circle hash table will
 not be allocated unless necessary.*")

sys:
(DEFMACRO 4sys::print-circle* (&body body)
  `(IF (NOT *print-circle*) 
       (PROGN . ,body)
       ;1;; Modded here by JPR to check for non top level printing.*
       (IF (OR *top-level-p*
	       (NOT (BOUNDP 'print-hash-table))
	       (NOT print-hash-table))
	   (LET ((print-label-number 0)
		 (print-hash-table nil))
	     (UNWIND-PROTECT (PROGN
			       (SETQ print-hash-table (get-print-hash-table))
			       (CLRHASH print-hash-table)
			       (print-record-occurrences object)
			       . ,body)
	       (WHEN print-hash-table
		 (SETQ reusable-print-hash-table print-hash-table))))
	   ;1;; This bit added by JPR.*
	   (PROGN ,@body))))

;1; The following functions only included to recompile them in the context of the macro above.*
;1;  This will not be necessary when release 7.0 is available.*

#-clos
sys:
(DEFUN 4sys::print* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed, with a Return before and a Space after.*"
  (SETQ stream (decode-print-arg stream))
  (FUNCALL stream :tyo (pttbl-newline *readtable*))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(PPRINT object stream)
	(PROGN 
	  (print-circle (print-object object 0 stream))
	  (FUNCALL stream :tyo (pttbl-space *readtable*)))))
  object)

#+clos
sys:
(DEFUN 4sys::print* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed, with a Return before and a Space after.*"
  (SETQ stream (decode-print-arg stream))
  (FUNCALL stream :tyo (pttbl-newline *readtable*))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(PPRINT object stream)
	;1(progn*
	(LET ((*prindepth* 0))
	  (print-circle (ticlos:print-object object stream))
	  (FUNCALL stream :tyo (pttbl-space *readtable*)))))
  object)

#-clos
sys:
(DEFUN 4sys::prin1* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprin1 object stream)
	(print-circle (print-object object 0 stream ))))
  object) 

#+clos
sys:
(DEFUN 4sys::prin1* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprin1 object stream)
	(LET ((*prindepth* 0))
	      (print-circle (ticlos:print-object object stream )))))
  object)

#-clos
sys:
(DEFUN 4sys::write* (object &key &optional (STREAM *standard-output*) ((:escape *print-escape*) *print-escape*)
  ((:radix *print-radix*) *print-radix*) ((:base *print-base*) *print-base*)
  ((:circle *print-circle*) *print-circle*) ((:pretty *print-pretty*) *print-pretty*)
  ((:level *print-level*) *print-level*) ((:length *print-length*) *print-length*)
  ((:case *print-case*) *print-case*) ((:gensym *print-gensym*) *print-gensym*)
  ((:array *print-array*) *print-array*))
  "2Print OBJECT on STREAM.  Keyword args control parameters affecting printing.
The argument ESCAPE specifies the value for the flag *PRINT-ESCAPE*, and so on.
For any flags not specified by keyword arguments, the current special binding is used.*"
  (LET ((character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(LET ((*standard-output* (decode-print-arg stream)))
	  (output-pretty-object object))
	(print-circle (print-object object 0 (decode-print-arg stream))))
  object))

#+clos
sys:
(DEFUN 4sys::write* (object &key &optional (STREAM *standard-output*) ((:escape *print-escape*) *print-escape*)
  ((:radix *print-radix*) *print-radix*) ((:base *print-base*) *print-base*)
  ((:circle *print-circle*) *print-circle*) ((:pretty *print-pretty*) *print-pretty*)
  ((:level *print-level*) *print-level*) ((:length *print-length*) *print-length*)
  ((:case *print-case*) *print-case*) ((:gensym *print-gensym*) *print-gensym*)
  ((:array *print-array*) *print-array*))
  "2Print OBJECT on STREAM.  Keyword args control parameters affecting printing.
The argument ESCAPE specifies the value for the flag *PRINT-ESCAPE*, and so on.
For any flags not specified by keyword arguments, the current special binding is used.*"
  (LET ((character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(LET ((*standard-output* (decode-print-arg stream)))
	  (print-circle (output-pretty-object object)))
	(LET ((*prindepth* 0))
	  (print-circle (ticlos:print-object object (decode-print-arg stream))) ) )
  object))

#-clos
sys:
(DEFUN 4sys::prin1-then-space* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed, followed by a Space character.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprin1 object stream)
	(print-circle (print-object object 0 stream)))
  (FUNCALL stream :tyo (pttbl-space *readtable*)))
  object)

#+clos
sys:
(DEFUN 4sys::prin1-then-space* (object &optional stream)
  "2Print OBJECT on STREAM with quoting if needed, followed by a Space character.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* t)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprin1 object stream)
	(LET ((*prindepth* 0))
	  (print-circle (ticlos:print-object object stream))))
  (FUNCALL stream :tyo (pttbl-space *readtable*)))
  object)

#-clos
sys:
(DEFUN 4sys::princ* (object &optional stream)
  "2Print OBJECT with no quoting, on STREAM.
Strings and characters print just their contents with no delimiters or quoting.
Pathnames, editor buffers, host objects, and many other hairy things
 print as their names with no delimiters.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* nil)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprinc object stream)
	(print-circle (print-object object 0 stream))))
  object)


#+clos
sys:
(DEFUN 4sys::princ* (object &optional stream)
  "2Print OBJECT with no quoting, on STREAM.
Strings and characters print just their contents with no delimiters or quoting.
Pathnames, editor buffers, host objects, and many other hairy things
 print as their names with no delimiters.*"
  (SETQ stream (decode-print-arg stream))
  (LET ((*print-escape* nil)
	(character-attribute-table (character-attribute-table *readtable*)))
    (IF *print-pretty*
	(pprinc object stream)
	(LET ((*prindepth* 0))
	  (print-circle (ticlos:print-object object stream)))))
  object)

;1---------------------------------------------------------------------------*
;1(LET ((compiler:compile-encapsulations-flag t))*
;1     (ADVISE sys:print-object :around :bind-top-level nil*
;1       (LET ((sys:*top-level-p* nil))*
;1            (DECLARE (SPECIAL sys:*top-level-p*))*
;1            :do-it)))*
;1----------------------------------------------------------------------------*

(DEFUN 4print-object* (EXP i-prindepth stream 
		     &optional (which-operations (sys::which-operations-for-print stream)) 
		     &aux nss)
  ;1; from advice commented above *
  (LET ((sys::*top-level-p* nil))
    (DECLARE (SPECIAL sys::*top-level-p*))
    ;1; ----- original code before advice ----- *
    (CATCH-CONTINUATION-IF t 'print-object
	#'(lambda ()
	    (FORMAT stream "3...error printing *")
	    (printing-random-object (EXP stream :typep :fastp t ))
	    (FORMAT stream "3...*"))
	()
      (CONDITION-RESUME
	'((ERROR) :abort-printing t ("3Give up trying to print this object.*")
	  catch-error-restart-throw print-object)
	(OR
	  (AND (MEMBER :print which-operations :test #'EQ)
	       ;1; Allow stream to intercept print operation*
	       (SEND stream :print exp i-prindepth *print-escape*))
	  (AND *print-circle* (%pointerp exp)
	       (OR (NOT (SYMBOLP exp)) (NOT (SYMBOL-PACKAGE exp)))
	       ;1; This is a candidate for circular or shared structure printing.*
	       ;1; See what the hash table says about the object:*
	       ;1; NIL - occurs only once.*
	       ;1; T - occurs more than once, but no occurrences printed yet.*
	       ;1; Allocate a label this time and print #label= as prefix.*
	       ;1; A number - that is the label.  Print only #label#.*
	       (CATCH 'label-printed
		 (sys::modifyhash exp sys::print-hash-table 
				  #'(lambda (key value key-found-p stream)
				      key
				      key-found-p
				      (COND
					((NULL value) NIL)
					((EQ value t)
					 (LET ((label (INCF sys::print-label-number))
					       (*print-base* 10.)
					       (*print-radix* NIL)
					       (*nopoint t))
					   (SEND stream :tyo #\#)
					   (sys::print-fixnum label stream)
					   (SEND stream :tyo #\=)
					   label))
					(t
					 (LET ((*print-base* 10.)
					       (*print-radix* NIL)
					       (*nopoint t))
					   (SEND stream :tyo #\#)
					   (sys::print-fixnum value stream)
					   (SEND stream :tyo #\#)
					   (THROW 'label-printed
						  t)))))
				  stream)
		 ()))
	  (TYPECASE exp
	    (fixnum (sys::print-fixnum exp stream))
	    (symbol (sys::print-pname-string exp stream t ))
	    (LIST
	     (IF (AND *print-level* (>= i-prindepth *print-level*))
		 (sys::print-raw-string (sys::pttbl-prinlevel *readtable*) stream t )
		 (PROGN
		   (IF *print-pretty*
		       (IF *print-escape*
			   (pprin1 exp stream)
			   (pprinc exp stream))
		       (sys::print-list exp i-prindepth stream which-operations)))))
	    (STRING
	     (IF (<= (ARRAY-ACTIVE-LENGTH exp) (ARRAY-TOTAL-SIZE exp))
		 (sys::print-quoted-string exp stream t)
		 (sys::print-random-object exp stream t i-prindepth
					   which-operations)))
	    (instance
	     (SEND exp :print-self stream i-prindepth *print-escape*))
	    (named-structure
	     (IGNORE-ERRORS (SETQ nss (NAMED-STRUCTURE-P exp)))
	     (COND
	       ((AND (SYMBOLP nss)
		     (OR (GET nss 'NAMED-STRUCTURE-INVOKE)
			 (GET nss :named-structure-invoke))
		     (MEMBER :print-self
			     (NAMED-STRUCTURE-INVOKE exp :which-operations)
			     :test #'EQ))
		(NAMED-STRUCTURE-INVOKE exp :print-self stream i-prindepth
					*print-escape*))
	       (t	   ;1; Named structure that doesn't print itself*
		(sys::print-named-structure nss exp i-prindepth stream
					    which-operations))))
	    (ARRAY (sys::print-array exp stream t  i-prindepth which-operations))
	    (FLOAT (sys::print-flonum exp stream ()))
	    (bignum (sys::print-bignum exp stream t ))
	    (RATIONAL (sys::print-rational exp stream t))
	    (COMPLEX (sys::print-complex exp stream t))
	    (CHARACTER
	     (IF (NOT *print-escape*)
		 (WRITE-CHAR exp stream)
		 (PROGN
		   (SEND stream :string-out
			 (sys::pttbl-character-before-font *readtable*))
		   (IF (LDB-TEST %%ch-font exp)
		       (LET ((*print-base* 10.)
			     (*print-radix* NIL)
			     (*nopoint t))
			 (PRIN1 (LDB %%ch-font exp) stream)))
		   (SEND stream :string-out
			 (sys::pttbl-character-prefix *readtable*))
		   (LET ((real-bits (LDB  %%kbd-control-meta exp))
			 (CHAR (CHAR-CODE exp)))
		     (SEND stream :string-out
			   (NTH real-bits
				'("" "3c-*" "3m-*" "3c-m-*" "3s-*" "3c-s-*" "3m-s-*"
				  "3c-m-s-*" "3h-*" "3c-h-*" "3m-h-*" "3c-m-h-*" "3s-h-*"
				  "3c-s-h-*" "3m-s-h-*" "3c-m-s-h-*")))
		     (LET ((chname (sys::ochar-get-character-name (DPB 0 %%kbd-control-meta
								       (DPB 0 %%ch-font exp)))))
		       (IF chname (SEND stream :string-out chname)
			   (PROGN
			     (WHEN (CHAR-BIT exp :mouse)
			       (WRITE-STRING "3mouse-*" stream))
			     (WHEN (CHAR-BIT exp :keypad)
			       (WRITE-STRING "3keypad-*" stream))
			     (WHEN (AND (/= (CHAR-BITS exp) 0) (sys::character-needs-quoting-p char))
			       (PRINC (sys::pttbl-slash *readtable*)  stream))
			     (SEND stream :tyo char))))))))
	    (number
	     (sys::print-raw-string (sys::pttbl-open-random *readtable*) stream t)
	     (sys::print-raw-string (SYMBOL-NAME (DATA-TYPE exp)) stream t)
	     (SEND stream :tyo (sys::pttbl-space *readtable*))
	     (LET ((*print-base* 8.)
		   (*print-radix* NIL))
	       (sys::print-fixnum (%pointer exp) stream))
	     (sys::print-raw-string (sys::pttbl-close-random *readtable*) stream t))
	    (t   ;1; Some random type we don't know about*
	     (sys::print-random-object exp stream t i-prindepth which-operations))))))
    ) 
  ;1; -------- end of orig code for advice ----------*
  exp)

;1; By JPR.*
(DEFVAR 4sys::*make-structure-instances-mouse-sensitive** t
"2When true Defstruct instances will be printed mouse sensitively in the inspector.*")

sys:
(DEFUN 4sys::print-named-structure* (nss exp i-prindepth stream which-operations)
  (DECLARE (SPECIAL *print-structure*))
;1  (declare (optimize (safety 0) (speed 3))) ;;; Fix this when TI does its thing. !!! JPR.*
  (LET ((description (GET nss 'defstruct-description)))
    (IF (OR (NOT description)
	    (IF (BOUNDP '*print-structure* )
		 (NULL *print-structure*)
		 (NULL *print-array*)))
	(printing-random-object (EXP stream :typep))
        (PROGN
          (FUNCALL stream :string-out "3#S*")
          (LET ((slot-alist (defstruct-description-slot-alist))
                (l (LIST nss)))
            (DOLIST (s slot-alist)
	      (UNLESS (defstruct-slot-description-name-slot-p (CDR s))
		(LET* ((kwd (INTERN (SYMBOL-NAME (CAR s)) pkg-keyword-package))
		       (fun (defstruct-slot-description-ref-macro-name (CDR s)))
		       (init (defstruct-slot-description-init-code (CDR s)))
		       (val (eval1 `(,fun ,exp)))) ;1; watch out for macros!*
		  
		  (UNLESS (EQUAL val init)
		    (PUSH kwd l)
		    (PUSH val l)))))
	    ;1; The next expression used to be (print-object body i-prindepth stream which-operations)*
	    ;1; Changed by JPR.*
	    (LET ((body (NREVERSE l)))
		 (IF *make-structure-instances-mouse-sensitive*
		     (FORMAT stream "3(~ ~)*" (FIRST body) *print-escape*
			     (REST body) *print-escape*)
		     (print-object body i-prindepth stream which-operations))))))))

;1-------------------------------------------------------------------------------*

(DEFUN 4grind-into-list-io* (op &optional arg1 &rest rest)
  (COND
    ((EQ op :which-operations) '(:tyo :line-out :string-out))
    ((EQ op :tyo)
     (COND
       ((= arg1 #\Newline)
	(COND
	  (grind-into-list-string
	   (PUSH grind-into-list-string grind-into-list-list)
	   (SETQ grind-into-list-line (1+ grind-into-list-line))
	   (AND grind-into-list-items-p
		(PUSH () grind-into-list-items))))
	;1; Modified here by JPR to use a fat string not the standard one.  *
	;1; This stops if from throwing away font information.*
	(SETQ grind-into-list-string
	      ;1;; 'string-char changed to fat-char by JPR.*
              ;1;; :element-type 'fat-char*
	      (MAKE-ARRAY 50 :type 'art-fat-string :leader-list '(0))))
       (t (VECTOR-PUSH-EXTEND arg1 grind-into-list-string))))
    ;1; String-out and Line-out methods provided by JPR because the*
    ;1; STREAM-DEFAULT-HANDLER throws away font information.*
    ((OR (EQ op :string-out) (EQ op :line-out))
     (LET ((tem (IF (TYPEP arg1 'ARRAY) arg1 (STRING arg1)))
	   (fctn 'grind-into-list-io))
          (DO ((len (COND ((SECOND rest) (SECOND rest))
			  (t (LENGTH tem))))
	       (i (COND ((FIRST rest)) (t 0))
		  (1+ i)))
	      ((>= i len) nil)
	    (SEND fctn :tyo (AREF tem i)))
	  (AND (EQ op :line-out)
	       (SEND fctn :tyo #\newline))))
    (t (STREAM-DEFAULT-HANDLER 'grind-into-list-io op arg1 rest))))

;1-------------------------------------------------------------------------------*

;1; String printer patches...*

;1; by JPR.*
sys:
(DEFUN 4sys::string-and-stream-ok* (STRING stream)
"2True if the string is an art-string or if the string is fat and the stream
 knows how to cope with printing fat strings in fonts.*"
  (OR (EQ (ARRAY-TYPE string) 'art-string)
      (AND (EQ (ARRAY-TYPE string) 'art-fat-string)
	   (OR (TYPEP stream 'tv::inspect-window)
	       (TYPEP stream 'tv::inspect-history-window)
	       ;1; (typep stream 'tv:shifting-stream) ;; TAC 08-09-89 removed this type of stream  *
	       ))))

sys:
(DEFUN 4sys::print-quoted-string* (STRING stream fastp &aux tem char (slash (pttbl-slash *readtable*)))
    (DECLARE (IGNORE fastp))
    (COND
      ((NOT *print-escape*) (print-raw-string string stream t))
      (t (FUNCALL stream :tyo (pttbl-open-quote-string *readtable*))
	 (SETQ tem (LENGTH string))
	 (COND
	   ((AND (string-and-stream-ok string stream)
		 ;1; Modded here by JPR to accept fonted strings.*
		 (DO ((i 0 (1+ i))
		      (ch))
		     ((>= i tem) t)
		   (AND (OR (CHAR= (SETQ ch (AREF string i)) slash)
			    (CHAR= ch #\"))
			(RETURN ()))))
	    ;1; There are no double quotes, and so no slashifying.*
	    
	    (FUNCALL stream :string-out string))
	   ;1; Modded here by JPR to accept fonted strings.*
	   ((string-and-stream-ok string stream)
	    (DO ((i 0 (1+ i)))
		((>= i tem) nil)
	      (SETQ char (LDB %%ch-char (AREF string i)))
	      (WHEN 
		(OR (CHAR= char slash) (CHAR= char #\"))
		(FUNCALL stream :tyo slash))
	      (FUNCALL stream :tyo (AREF string i))))
	   (t
	    (DO ((i 0 (1+ i)))
		((>= i tem) nil)
	      (SETQ char (LDB %%ch-char (AREF string i)))
	      (WHEN 
		(OR (CHAR= char slash) (CHAR= char #\"))
		(FUNCALL stream :tyo slash))
	      (FUNCALL stream :tyo char))))
	 (FUNCALL stream :tyo (pttbl-close-quote-string *readtable*)))))

sys:
(DEFUN 4sys::print-raw-string* (STRING stream fastp &aux tem)
    (DECLARE (IGNORE fastp))
    (COND
      ;1; Modded here by JPR to accept fonted strings.*
      ((AND t (string-and-stream-ok string stream))
       (FUNCALL stream :string-out string))
      (t (SETQ tem (ARRAY-ACTIVE-LENGTH string))
	 (DO ((i 0 (1+ i)))
	     ((>= i tem) nil)
	   (FUNCALL stream :tyo (LDB %%ch-char (AREF string i)))))))

;1-------------------------------------------------------------------------------*

;1;; By JPR*
sys:
(DEFUN 4sys::make-fat-output-string-stream* ()
"2Returns a fat-string string output stream.*"
  (MAKE-STRING-OUTPUT-STREAM
    ;1; Changed by RDA to be :TYPE 'ART-FAT-STRING as :ELEMENT-TYPE 'FAT-CHAR doens't work.*
    (MAKE-ARRAY 50 :type 'art-fat-string :leader-list '(0))))

sys:
(DEFRESOURCE 4sys::pprint-resource* ()
  :constructor (LET ((print-structure (MAKE-ARRAY (* 100 (size-of-pp-obj))
			   :fill-pointer 0))
		     (pprint-buffer-stream
		       ;1; Modded by JPR to use fat strings.  This lets font info be printed properly.*
		       (sys::make-fat-output-string-stream)))
		 (pprint-init)
		 (CONS print-structure pprint-buffer-stream))
  :deallocator pprint-resource-deallocator 
  :initial-copies 0)

;1; CLear the resource, since there may be some old thin strings in it.*
(CLEAR-RESOURCE 'sys::pprint-resource)
